@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<div class="row">
                   <div class="col-sm-12 m-b-15">
                        <div class="btn-group pull-right m-t-15">
                            <a href="/dashboard/companies/{{$company->id}}/edit" class="btn btn-info waves-effect w-md waves-light m-b-5">
                                <i class="fa fa-pencil m-r-5"></i>
                                <span>تعديل</span>
                            </a>

                            <a href="{{route('companies.destroy',$company)}}" id="delete-btn" class="btn btn-info btn-danger waves-effect w-md waves-light m-b-5 m-l-5">
                                <i class="fa fa-remove"></i>
                                <span>حذف</span>
                            </a>
                        </div>
                        <h4 class="page-title"><i class="fa fa-home"></i>   {{ $company->name }} </h4>
                    </div>
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-color panel-tabs panel-success">
                            <div class="panel-heading panel-heading-custom">
                                <ul class="nav nav-pills">
                                    <li class="active">
                                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                                    </li>
                                    <li class="">
                                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">الحافلات</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="panel-body">
                                <div class="tab-content">
                                    <div id="navpills-1" class="tab-pane fade in active">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-bordered table-striped text-center m-0">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center" colspan="4">البيانات الأساسية</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الاسم</td>
                                                            <td>{{$company->name}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>البريد الالكتروني</td>
                                                            <td>{{$company->email}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الجوال</td>
                                                            <td>{{$company->phone}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>الصورة</td>
                                                            <td>
                                                                <img src="{{GetImage($company->image ?? '')}}" width="150" height="150">
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                    </div>
                                    <div id="navpills-2" class="tab-pane fade">
                                        <div class="row">
                                            @foreach($company->OrganizationBus()->get() as $bus)
                                            <div class="col-lg-6 ">
                                                <table  class="table m-0" style="width: 100%; ">
                                                    <thead >
                                                        <tr>
                                                            <th colspan="4" class="text-center">
                                                                <a href="{{ route('buses.show', $bus->Bus->id) }}">
                                                                البيانات الحافلة رقم ({{$bus->Bus->id ?? ''}})
                                                                </a>
                                                            </th>
                                                            <th></th>
                                                            <th></th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>رقم   <span style="padding-right: 40px;">{{$bus->Bus->id ?? ''}}</span></td>
                                                        </tr>
                                                        <tr>
                                                            <td>نوع المعده  <span style="padding-right: 40px;"> {{$bus->Bus->BusType->name ?? ''}} </span></td>
                                                        </tr>
                                                        <tr>
                                                            <td>اسم المعده    <span style="padding-right: 40px;"> {{$bus->Bus->BusClass->name ?? ''}} </span></td>
                                                        </tr>
                                                        <tr>
                                                            <td> اسم السائق <span style="padding-right: 40px;"> {{$bus->Bus->Driver->name ?? ''}} </span></td>
                                                        </tr>
                                                        <tr>
                                                            <td> اسم المندوب <span style="padding-right: 40px;"> {{$bus->Bus->attendant_name ?? ''}} </span></td>
                                                        </tr>
                                                        <tr>
                                                            <td> الصورة <span style="padding-right: 40px;"> <img src="{{GetImage($bus->Bus->attendant_image ?? '')}}" width="150" height="150"> </span></td>
                                                        </tr>
                                                        <tr>
                                                            <td> الشسية <span style="padding-right: 40px;"> {{$bus->Bus->chassis ?? ''}} </span></td>
                                                        </tr>
                                                        <tr>
                                                            <td> اسم المالك <span style="padding-right: 40px;"> {{$bus->Bus->owner_name ?? ''}} </span></td>
                                                        </tr>
                                                        <tr>
                                                            <td> الموديل <span style="padding-right: 40px;"> {{$bus->Bus->model ?? ''}} </span></td>
                                                        </tr>
                                                        <tr>
                                                            <td> نوع الرحلة <span style="padding-right: 40px;"> {{$bus->Bus->trip_type ?? ''}} </span></td>
                                                        </tr>
                                                        <tr>
                                                            <td> المرحلة التعليمية <span style="padding-right: 40px;"> {{$bus->Bus->EducationalLevel->name ?? ''}} </span></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                </div>
                <!-- end row -->

@endsection
@section('script')
@endsection