@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<div class="row">
                   <div class="col-sm-12 m-b-15">
                        <div class="btn-group pull-right m-t-15">
                            <a href="/dashboard/drivers/{{$driver->id}}/edit" class="btn btn-info waves-effect w-md waves-light m-b-5">
                                <i class="fa fa-pencil m-r-5"></i>
                                <span>تعديل</span>
                            </a>

                            <a href="{{route('drivers.destroy',$driver)}}" id="delete-btn" class="btn btn-info btn-danger waves-effect w-md waves-light m-b-5 m-l-5">
                                <i class="fa fa-remove"></i>
                                <span>حذف</span>
                            </a>
                        </div>
                        <h4 class="page-title"><i class="fa fa-home"></i>   {{ $driver->name }} </h4>
                    </div>
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-color panel-tabs panel-success">
                            <div class="panel-heading panel-heading-custom">
                                <ul class="nav nav-pills">
                                    <li class="active">
                                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                                    </li>
                                    <li class="">
                                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">الباص</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="panel-body">
                                <div class="tab-content">
                                    <div id="navpills-1" class="tab-pane fade in active">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="4">البيانات الأساسية</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الاسم</td>
                                                            <td>{{$driver->name}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>البريد الالكتروني</td>
                                                            <td>{{$driver->email}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الجوال</td>
                                                            <td>{{$driver->phone}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>الصورة الشخصية</td>
                                                            <td>
                                                                <img src="{{GetImage($driver->image)}}" height="150" width="200">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الهوية</td>
                                                            <td>{{$driver->identity}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>صورة الهوية</td>
                                                            <td>
                                                                <img src="{{$driver->identity_image}}" height="150" width="200">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الرخصة</td>
                                                            <td>{{$driver->license}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>صورة الرخصة</td>
                                                            <td>
                                                                <img src="{{$driver->license_image}}" height="150" width="200">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الاستمارة</td>
                                                            <td>{{$driver->form}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>صورة الاستمارة</td>
                                                            <td>
                                                                <img src="{{$driver->form_image}}" height="150" width="200">
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                            <div class="col-md-6">
                                            </div>
                                        </div>
                                    </div>
                                    <div id="navpills-2" class="tab-pane fade">
                                        <div class="row">
                                            <div class="col-md-6">
                                            <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="4">بيانات الباص</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if( $driver->Bus()->first() )
                                                        <?php $bus = $driver->Bus()->first();?>
                                                        <tr>
                                                            <td>رقم الباص    </td><td>{{$bus->id ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>نوع الباص   </td><td> {{$bus->BusType->name ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td>فئة المعدة     </td><td> {{$bus->BusClass->name ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td> اسم السائق  </td><td> {{$bus->Driver->name ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td> اسم المرافق  </td><td> {{$bus->attendant_name ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td> صورة المرافق  </td><td> <img src="{{GetImage($bus->attendant_image ?? '')}}" width="150" height="150"> </td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم  الشاسية  </td><td> {{$bus->chassis ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td> اسم المالك  </td><td> {{$bus->owner_name ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td> الموديل  </td><td> {{$bus->model ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td> نوع الرحلة  </td><td> {{$bus->trip_type ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td> المرحلة التعليمية  </td>
                                                            <td> {{$bus->EducationalLevel->name ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td> عدد المقاعد  </td>
                                                            <td> {{$bus->seats ?? ''}} </td>
                                                        </tr>
                                                        <tr>
                                                            <td> عرض الباص  </td>
                                                            <td>
                                                                <a href="{{route('buses.show',$bus->id)}}">عرض</a>
                                                            </td>
                                                        </tr>
                                                        @endif
                                                    </tbody>
                                                </table> 
                                        </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                </div>
                <!-- end row -->

@endsection
@section('script')
@endsection