@extends('admin.layout.app')
@section('style')
@endsection
@section('content')


                <!-- Page-Title -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="btn-group pull-right m-t-15">
                            <a href="{{url('/dashboard/drivers/create')}}" class="btn btn-info waves-effect w-md waves-light m-b-5">
                                <i class="fa fa-pencil m-r-5"></i>
                                <span>إضافة  جديد</span>
                            </a>
                        </div>
                        <h4 class="page-title">قسم السائقين</h4>
                        <div class="card-box">
                            <form action="" method="get">
                                <div class="row">
                                    <div class="col-md-12 part-top">
                                        <div class="row">
                                         
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="row">
                                            
                                            <div class="col-lg-4">
                                                <div class="form-horizontal">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <input type="text" name="phone" class="form-control" value="{{(array_key_exists('phone', $search))? $search['phone'] : ''}}" placeholder="رقم الجوال ">
                                                            
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>

                                            <div class="col-lg-4">
                                                <div class="form-horizontal">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <input type="text" name="name" value="{{(array_key_exists('name', $search))? $search['name'] : ''}}" class="form-control" placeholder="اسم السائق">
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="row">

                                            <div class="col-md-4">
                                                <div class="form-horizontal m-b-15">
                                                    <button type="button" onclick="$(this).closest('form').find('#excel').remove(); $(this).closest('form').submit();" class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i class="fa fa-search"></i> بحث</button>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-horizontal">
                                                    <a href="{{ route('drivers.index') }}" class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i class="fa fa-trash"></i> مسح خيارات البحث</a>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-horizontal">
                                                @if(auth()->user()->role == 'admin')
                                                    <button type="button" target="_blank" onclick="$(this).closest('form').prepend(`<input name='excel' id='excel' type='hidden' value='1' />`); $(this).closest('form').submit();" class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10">تصدير لExcel</button>
                                                @endif
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

<div class="row">
                    
                    <div class="col-sm-12">
                        <div class="card-box ">
                            <div class="row">

                                <div class="col-md-12">
                                    <div class="tab-content">

                                            <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>اسم </th>
                                                        <th>الايميل</th>
                                                        <th>رقم التليفون</th>
                                                        <th>الصورة</th>
                                                        <th>تعديل</th>
                                                        <th>حذف</th>
                                                        <th>الباص</th>
                                                    </tr>
                                                </thead>

                                                @foreach($drivers as $item)
                                                    <tr>
                                                        <td> {{$item->id}}</td>
                                                        <td> <a href="{{route('drivers.show',$item->id)}}">{{$item->name}}</a></td>
                                                        <td>{{$item->email}}</td>
                                                        <td>{{$item->phone}}</td>
                                                        <td>
                                                            <img src="{{GetImage($item->image)}}" height="100" width="100">
                                                        </td>
                                                        <td><a href="{{ route('drivers.edit', $item->id) }}"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                                        
                                                        <td> <a href="{{route('drivers.destroy',$item)}}" id="delete-btn"  ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                                        <td>
                                                            <!-- <a href="{{route('sons.index',$item->id)}}" class="btn waves-effect btn-default pull-right client-info" > عرض </a> -->
                                                            @if( $item->Bus()->first() )
                                                            <a href="{{ route('buses.show', $item->Bus->id) }}">عرض الباص</a>
                                                            @else
                                                            <a href="{{ route('buses.create').'?driver_id='.$item->id }}">اضافة الباص</a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                            </table>
                                    </div>
                                    
                                </div>
                            </div>
                            
                        </div>
                    </div><!-- end col -->
                </div>
                <!-- end row -->
                <div class="col-sm-12">
                        {{ $drivers->appends($search)->links() }}
                    </div>

                <div id="modal-delete" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="custom-width-modalLabel" aria-hidden="true">
                    <div class="modal-dialog" style="width:55%;">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4 class="modal-title" id="custom-width-modalLabel">هل تريد الحذف </h4>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">إلغاء الامر</button>
                                <button type="button" class="btn btn-primary buunton-notofication waves-effect waves-light" data-type="success"  data-message="تم الحذف">حذف</button>
                            </div>
                        </div><!-- /.modal-content -->
                    </div><!-- /.modal-dialog -->
                </div>

                <div id="info-modal" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="custom-width-modalLabel" aria-hidden="true">
                    <div class="modal-dialog" style="width:55%;">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4 class="modal-title" id="custom-width-modalLabel">بيانات العميل </h4>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-12" id="client-info-box">
                                        {{--  --}}
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                            </div>
                        </div><!-- /.modal-content -->
                    </div><!-- /.modal-dialog -->
                </div>
                                                    
                                            
@endsection
@section('script')


        <script type="text/javascript">
            // $('#datatable-0, #datatable-1, #datatable-2, #datatable-3, #datatable-4').DataTable( {
            //     "bLengthChange" : false, //thought this line could hide the LengthMenu
            //     "bInfo":false,  
            // } );
            
            // $('.buunton-notofication').on('click',function(){
            //     var type = $(this).data('type');     
            //     var message = $(this).data('message');     
            //     switch(type){
            //         case 'error' : toastr.error(message);  break;
            //         case 'success' : toastr.success(message);  break;
            //         case 'info' : toastr.info(message);  break;
            //         case 'warning' : toastr.warning(message);  break; 
            //     }
            //     return false;
            // });
            // TableManageButtons.init();

            $(document).on('click', '.client-info', function(){
                $.get( "{{url('/dashboard/user-info')}}" + "/" + $(this).attr('data-id'), function( data ) {
                    $('#client-info-box').html(data);
                });
            });
        </script>
@endsection