@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
                <!-- Page-Title -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="title-page sub-header-title-custom">
                            <h5 style="color: inherit;"><a href="#"><span> الحركات المالية </span><i class="fa fa-angle-left" style="padding: 0 5px; color:inherit;"></i></a><span>نطره عامة</span></h5>
                        </div>
                    </div>
                </div>


                <div class="row">
                    
                    <div class="col-sm-12">
                        <div class="card-box ">
                            <div class="row">
                                    <div class="col-sm-12">
                                        <h4 class="title">
                                            التطبيق
                                        </h4>
                                    </div>
                                <div class="col-sm-12">
                                            <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                <thead>
                                                    <tr>
                                                        <th>المدين</th>
                                                        <th> القيمة</th>
                                                        <th>الطلب  </th>
                                                        <th> الحالة </th>
                                                    </tr>
                                                </thead>

                                                <tbody>
                                                    @foreach($incomes as $item)
                                                    <tr>
                                                        <td>
                                                            @if ($item->taggable_type == 'App\Models\School')
                                                                <a href="{{route('schools.show',$item->taggable_id)}}">
                                                                    {{$item->School->name ?? ''}}
                                                                </a>
                                                            @elseif ($item->taggable_type == 'App\Models\Company')
                                                                <a href="{{route('companies.show',$item->taggable_id)}}">
                                                                    {{$item->Company->name ?? ''}}
                                                            @elseif ($item->taggable_type == 'App\Models\Bus')
                                                                <a href="{{route('buses.show',$item->taggable_id)}}">
                                                                    باص رقم : {{$item->Bus->id ?? ''}}
                                                                </a>
                                                            @elseif ($item->taggable_type == 'App\Models\User')
                                                                <a href="{{route('users.show',$item->taggable_id)}}">
                                                                    {{$item->Parent->name ?? ''}}
                                                                </a>
                                                            @endif
                                                        </td>
                                                        <td> {{ $item->amount ?? '' }} </td>
                                                        <td>  {{ $item->order_id ?? '' }} </td>
                                                        <td> 
                                                                @if($item->active == '1')
                                                                تم التحصيل
                                                                @else
                                                                {!!Form::model($item , ['url' => ['/dashboard/payments/'.$item->id] , 'method' => 'PATCH','files'=>true]) !!}
                                                                <input type="hidden" name="active" value="1">
                                                                <input type="submit" class="btn btn-success" value="تم التحصيل">
                                                                {!!Form::close() !!}
                                                                @endif
                                                        </td>
                                                    </tr>
                                                    @endforeach

                                                </tbody>
                                            </table>
                                </div>
                            </div>
                            
                        </div>
                        <div class="card-box ">
                            <div class="row">
                                <div class="col-sm-12">
                                    <h4 class="title">
                                           الشركات
                                    </h4>
                                </div>
                                <div class="col-sm-12">
                                    <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>المدين</th>
                                                <th> القيمة</th>
                                                <th>الطلب  </th>
                                                <th> الحالة </th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @foreach($company_outcomes as $item)
                                            <tr>
                                                <td>
                                                    التطبيق
                                                </td>
                                                <td> {{ $item->amount ?? '' }} </td>
                                                <td>  {{ $item->order_id ?? '' }} </td>
                                                <td>
                                                    @if($item->active == '1')
                                                    تم السداد
                                                    @else
                                                    {!!Form::model($item , ['url' => ['/dashboard/payments/'.$item->id] , 'method' => 'PATCH','files'=>true]) !!}
                                                    <input type="hidden" name="active" value="1">
                                                    <input type="submit" class="btn btn-success" value="تم السداد">
                                                    {!!Form::close() !!}
                                                    @endif
                                                </td>
                                            </tr>
                                            @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="card-box ">
                            <div class="row">
                                <div class="col-sm-12">
                                    <h4 class="title">
                                           المدارس
                                    </h4>
                                </div>
                                <div class="col-sm-12">
                                    <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>المدين</th>
                                                <th> القيمة</th>
                                                <th>الطلب  </th>
                                                <th> الحالة </th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @foreach($school_outcomes as $item)
                                            <tr>
                                                <td>
                                                    التطبيق
                                                </td>
                                                <td> {{ $item->amount ?? '' }} </td>
                                                <td>  {{ $item->order_id ?? '' }} </td>
                                                <td>
                                                        @if($item->active == '1')
                                                        تم السداد
                                                        @else
                                                        {!!Form::model($item , ['url' => ['/dashboard/payments/'.$item->id] , 'method' => 'PATCH','files'=>true]) !!}
                                                        <input type="hidden" name="active" value="1">
                                                        <input type="submit" class="btn btn-success" value="تم السداد">
                                                        {!!Form::close() !!}
                                                        @endif
                                                    </td>
                                            </tr>
                                            @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="card-box ">
                            <div class="row">
                                <div class="col-sm-12">
                                    <h4 class="title">
                                           الافراد
                                    </h4>
                                </div>
                                <div class="col-sm-12">
                                    <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>المدين</th>
                                                <th> القيمة</th>
                                                <th>الطلب  </th>
                                                <th> الحالة </th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @foreach($bus_outcomes as $item)
                                            <tr>
                                                <td>
                                                    التطبيق
                                                </td>
                                                <td> {{ $item->amount ?? '' }} </td>
                                                <td>  {{ $item->order_id ?? '' }} </td>
                                                <td>
                                                        @if($item->active == '1')
                                                        تم السداد
                                                        @else
                                                        {!!Form::model($item , ['url' => ['/dashboard/payments/'.$item->id] , 'method' => 'PATCH','files'=>true]) !!}
                                                        <input type="hidden" name="active" value="1">
                                                        <input type="submit" class="btn btn-success" value="تم السداد">
                                                        {!!Form::close() !!}
                                                        @endif
                                                    </td>
                                            </tr>
                                            @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->
                </div>
                <!-- end row -->
@endsection
@section('script')
@endsection