@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
                <!-- Page-Title -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="btn-group pull-right m-t-15">
                            <a href="{{url('/school/school-buses/create')}}" class="btn btn-info waves-effect w-md waves-light m-b-5">
                                <i class="fa fa-pencil m-r-5"></i>
                                <span>إضافة  جديد</span>
                            </a>
                        </div>
                        <div class="title-page sub-header-title-custom">
                            <h5 style="color: inherit;"><a href="#"><span> الباصات </span><i class="fa fa-angle-left" style="padding: 0 5px; color:inherit;"></i></a><span>نطره عامة</span></h5>
                        </div>
                    </div>
                </div>


                <div class="row">
                    
                    <div class="col-sm-12">
                        <div class="card-box ">
                            <div class="row">
                                    <div class="col-sm-12">
                                        <h4 class="title">
                                            الحافلات الخاصة بك
                                        </h4>
                                    </div>
                                <div class="col-sm-12">
                                            <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                <thead>
                                                    <tr>
                                                        <th>الرقم</th>
                                                        <th>اسم السائق</th>
                                                        <th>رقم الجول  </th>
                                                        <th> المرحلة التعليميه </th>
                                                        <th> فئة الحافله   </th>
                                                        <th> نوع الحافله  </th>
                                                        <th> رقم الحافله</th>
                                                       
                                                        <!-- <th>الحاله</th> -->
                                                        <th>عرض </th>
                                                        <th>تعديل</th>
                                                        <th>حذف</th>
                                                    </tr>
                                                </thead>

                                                <tbody>
                                                    @foreach($buses as $item)
                                                    <tr>
                                                        <td>{{$item->id}}</td>
                                                        <td> {{ $item->Driver->name ?? '' }} </td>
                                                        <td>  {{ $item->Driver->phone ?? '' }} </td>
                                                        <td> {{ $item->EducationalLevel->name ?? '' }} </td>
                                                        <td>  {{ $item->BusClass->name ?? '' }}  </td>
                                                        <td>  {{ $item->BusType->name ?? '' }}  </td>
                                                        <td> {{ $item->noard_no ?? '' }}  </td>
                                                        
                                                        <!-- <td> {{__('school.'.$item->status)}} </td> -->
                                                        
                                                        <td><a href="/school/school-buses/{{$item->id}}" ><i class="fa fa-eye  m-r-10" style="color: #188ae2;"></i> عرض</a></td>
                                                        <td><a href="/school/school-buses/{{$item->id}}/edit"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                                        <td> <a href="{{route('buses.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                                    </tr>
                                                    @endforeach

                                                </tbody>
                                            </table>
                                </div>
                            </div>
                            
                        </div>
                        <div class="card-box ">
                            <div class="row">
                                <div class="col-sm-12">
                                    <h4 class="title">
                                        حافلات الربط مع الشركات
                                    </h4>
                                </div>
                                <div class="col-sm-12">
                                            <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                <thead>
                                                    <tr>
                                                        <th>الرقم</th>
                                                        <th>اسم السائق</th>
                                                        <th>رقم الجول  </th>
                                                        <th> المرحلة التعليميه </th>
                                                        <th> فئة الحافله   </th>
                                                        <th> نوع الحافله  </th>
                                                        <th> رقم الحافله</th>
                                                       
                                                        <!-- <th>الحاله</th> -->
                                                        <th>عرض </th>
                                                    </tr>
                                                </thead>

                                                <tbody>
                                                    @foreach(auth()->user()->SchoolCompanyBus()->get() as $item)
                                                    <tr>
                                                        <td>{{$item->Bus->id ?? ''}}</td>
                                                        <td> {{ $item->Bus->Driver->name ?? '' }} </td>
                                                        <td>  {{ $item->Bus->Driver->phone ?? '' }} </td>
                                                        <td> {{ $item->Bus->EducationalLevel->name ?? '' }} </td>
                                                        <td>  {{ $item->Bus->BusClass->name ?? '' }}  </td>
                                                        <td>  {{ $item->Bus->BusType->name ?? '' }}  </td>
                                                        <td> {{ $item->Bus->noard_no ?? '' }}  </td>
                                                        
                                                        <!-- <td> {{__('school.'.$item->Bus->status)}} </td> -->
                                                        
                                                        <td><a href="/school/school-buses/{{$item->Bus->id}}" ><i class="fa fa-eye  m-r-10" style="color: #188ae2;"></i> عرض</a></td>
                                                    </tr>
                                                    @endforeach

                                                </tbody>
                                            </table>
                                </div>
                            </div>
                            
                        </div>
                    </div><!-- end col -->
                </div>
                <!-- end row -->
@endsection
@section('script')
@endsection