@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<div class="row">
                   <div class="col-sm-12 m-b-15">
                        <div class="btn-group pull-right m-t-15">
                            <a href="/school/school-users/{{$user->id}}/edit" class="btn btn-info waves-effect w-md waves-light m-b-5">
                                <i class="fa fa-pencil m-r-5"></i>
                                <span>تعديل</span>
                            </a>

                            <a href="{{route('school-users.destroy',$user)}}" id="delete-btn" class="btn btn-info btn-danger waves-effect w-md waves-light m-b-5 m-l-5">
                                <i class="fa fa-remove"></i>
                                <span>حذف</span>
                            </a>
                        </div>
                        <h4 class="page-title"><i class="fa fa-home"></i>   {{ $user->name }} </h4>
                    </div>
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-color panel-tabs panel-success">
                            <div class="panel-heading panel-heading-custom">
                                <ul class="nav nav-pills">
                                    <li class="active">
                                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                                    </li>
                                    <li class="">
                                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">الابناء</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="panel-body">
                                <div class="tab-content">
                                    <div id="navpills-1" class="tab-pane fade in active">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="4">البيانات الأساسية</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الاسم</td>
                                                            <td>{{$user->name}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>البريد الالكتروني</td>
                                                            <td>{{$user->email}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الجوال</td>
                                                            <td>{{$user->phone}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                            <div class="col-md-6">
                                                {{--  <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="4">بيانات أخرى</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الطابق</td>
                                                            <td>1</td>
                                                        </tr>
                                                        <tr>
                                                            <td>عدد المداخل</td>
                                                            <td>1</td>
                                                        </tr>
                                                        <tr>
                                                            <td>وصف الوحدة</td>
                                                            <td>سكني عائلات</td>
                                                        </tr>
                                                        <tr>
                                                            <td>الغرف/الفتحات عدد</td>
                                                            <td>4</td>
                                                        </tr>
                                                        <tr>
                                                            <td>عدد دورات المياه</td>
                                                            <td>2</td>
                                                        </tr>
                                                        <tr>
                                                            <td>نموذج الوحدة</td>
                                                            <td>امامى</td>
                                                        </tr>
                                                    </tbody>
                                                </table>  --}}
                                            </div>
                                        </div>
                                    </div>
                                    <div id="navpills-2" class="tab-pane fade">
                                        <div class="row">
                                            @foreach($user->Son()->get() as $son)
                                            <div class="col-lg-4 ">
                                                <a href="{{url('/school/school-sons/'.$son->id)}}">
                                                    <div class="f-box f-box-un f-box-use">
                                                        <div class="row">

                                                            <div class="box-content">
                                                                <div class="con">
                                                                    <strong>#  </strong>
                                                                    <span class="">{{ $son->id }}</span>
                                                                </div>

                                                                <div class="con">
                                                                    <strong>الاسم</strong>
                                                                    <span class="">{{ $son->name ?? '' }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                </div>
                <!-- end row -->

@endsection
@section('script')
@endsection