@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<!-- Page-Title -->
<div class="row">
    <div class="col-sm-12">
        <div class="btn-group pull-right m-t-15">
            <a href="{{url('/dashboard/schoollists/create')}}" class="btn btn-info waves-effect w-md waves-light m-b-5">
                <i class="fa fa-pencil m-r-5"></i>
                <span>إضافة  </span>
            </a>
            {!!Form::open( ['url' => '/dashboard/schoollists/' ,'method' => 'Post','files' => true]) !!}
                <input type="file" name="excel"  class="btn btn-info waves-effect w-md waves-light m-b-5" onchange="$(this).closest('form').submit();"/>
                {!!Form::close() !!}
        </div>
        <h4 class="page-title">قائمة  المدارس</h4>
    </div>
</div>


<div class="row">
    
    <div class="col-sm-12">
        <div class="card-box table-responsive">
            <div class="row">

                <div class="col-md-12">
                    <div class="tab-content">

                        
                        <div role="tabpanel" class="tab-pane active" id="customers">
                            <table id="datatable-0" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th> الاسم </th>
                                        <th> العنوان </th>
                                        <th>عرض</th>
                                        <th>تعديل</th>
                                        <th>حذف</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($schools as $item)
                                    <tr>
                                        <td> {{$item->name}} </td>
                                        <td> {{$item->address}} </td>
                                        
                                        <td><a href="/dashboard/schoollists/{{$item->id}}"><i class="fa fa-eye  m-r-10" style="color: #188ae2;"></i> عرض</a></td>
                                        <td><a href="/dashboard/schoollists/{{$item->id}}/edit"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                        <td> <a href="{{route('schoollists.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        {!! $schools->links() !!}
                    </div>
                    
                </div>
            </div>
            
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->
@endsection
@section('script')
@endsection