@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<div class="row">
                   <div class="col-sm-12 m-b-15">
                        <div class="btn-group pull-right m-t-15">
                            <a href="/dashboard/schoollists/{{$school->id}}/edit" class="btn btn-info waves-effect w-md waves-light m-b-5">
                                <i class="fa fa-pencil m-r-5"></i>
                                <span>تعديل</span>
                            </a>

                            <a href="{{route('schoollists.destroy',$school)}}" id="delete-btn" class="btn btn-info btn-danger waves-effect w-md waves-light m-b-5 m-l-5">
                                <i class="fa fa-remove"></i>
                                <span>حذف</span>
                            </a>
                        </div>
                        <h4 class="page-title"><i class="fa fa-home"></i>   {{ $school->name }} </h4>
                    </div>
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-color panel-tabs panel-success">
                            <div class="panel-heading panel-heading-custom">
                                <ul class="nav nav-pills">
                                    <li class="active">
                                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="panel-body">
                                <div class="tab-content">
                                    <div id="navpills-1" class="tab-pane fade in active">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="4">البيانات الأساسية</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الاسم</td>
                                                            <td>{{$school->name}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>الجوال</td>
                                                            <td>{{$school->phone}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>المرحلة</td>
                                                            <td>{{$school->level}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>الجنس</td>
                                                            <td>{{$school->sex}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>السطلة</td>
                                                            <td>{{$school->type}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>العنوان</td>
                                                            <td>{{$school->address}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="col-md-6">
                                                <style>
                                              /* Always set the map height explicitly to define the size of the div
                                               * element that contains the map. */
                                              #map {
                                                height: 300px;
                                                width: 100%;
                                              }
                                            </style>
                                                <div id="map"></div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                </div>
                <!-- end row -->

@endsection
@section('script')
<script>
      var map;
      function initMap() {
          
      var features = JSON.parse('{!! $sons_list !!}');
      var features2 = JSON.parse('{!! $sons_list2 !!}');
      var featuresa = JSON.parse('{!! $buses_list !!}');
      var defLat = parseFloat('{{$school->lat}}');
      var defLng = parseFloat('{{$school->long}}');
    //   if(features.length > 0)
    //   {
    //       defLat = features[0].source_lat;
    //       defLng = features[0].source_long;
    //   }
        map = new google.maps.Map(
            document.getElementById('map'),
            {center: new google.maps.LatLng(defLat, defLng), zoom: 10});

        var iconBase =
            'https://developers.google.com/maps/documentation/javascript/examples/full/images/';

        var icons = {
          parking: {
            icon: iconBase + 'parking_lot_maps.png'
          },
          library: {
            icon: iconBase + 'library_maps.png'
          },
          info: {
            icon: iconBase + 'info-i_maps.png'
          }
        };

    //     var features = [
    //       {
    //         position: new google.maps.LatLng(-33.91721, 151.22630),
    //         type: 'info'
    //       },
    //   ];
        var content = '<div id="content">'+
        '<div id="siteNotice">fv'+
        '</div>';

    
        // var infowindow = new google.maps.InfoWindow()
        var marker = new google.maps.Marker({
            position: new google.maps.LatLng(defLat, defLng),
            icon:  'https://maps.google.com/mapfiles/ms/icons/flag.png',
            map: map
          });
        //   google.maps.event.addListener(marker,'click', (function(marker,content,infowindow){ 
        //             return function() {
        //             infowindow.setContent(content);
        //             infowindow.open(map,marker);
        //             };
        //         })(marker,content,infowindow)); 
        // Create markers.
        for (var i = 0; i < features.length; i++) {
          var marker = new google.maps.Marker({
            position: new google.maps.LatLng(features[i].source_lat, features[i].source_long),
            icon:  'https://maps.google.com/mapfiles/ms/icons/blue-pushpin.png',
            map: map
          });
            var content = "<a href='{{url('/dashboard/orders')}}/"+features[i].id+"/edit' target='_blank'> <h6> عرض الطلب "+  ' </h6> </a>' 

            var infowindow = new google.maps.InfoWindow()

            google.maps.event.addListener(marker,'click', (function(marker,content,infowindow){ 
                    return function() {
                    infowindow.setContent(content);
                    infowindow.open(map,marker);
                    };
                })(marker,content,infowindow)); 
        };
        for (var i = 0; i < features2.length; i++) {
          var marker = new google.maps.Marker({
            position: new google.maps.LatLng(features2[i].source_lat, features2[i].source_long),
            icon:  'https://maps.google.com/mapfiles/ms/icons/red-pushpin.png',
            map: map
          });
            var content = "<a href='{{url('/dashboard/orders')}}/"+features2[i].id+"/edit' target='_blank'> <h6> عرض الطلب "+  ' </h6> </a>' 

            var infowindow = new google.maps.InfoWindow()

            google.maps.event.addListener(marker,'click', (function(marker,content,infowindow){ 
                    return function() {
                    infowindow.setContent(content);
                    infowindow.open(map,marker);
                    };
                })(marker,content,infowindow)); 
        };
        for (var i = 0; i < featuresa.length; i++) {
            var marker = new google.maps.Marker({
            position: new google.maps.LatLng(featuresa[i].source_lat, featuresa[i].source_long),
            icon:  'https://maps.google.com/mapfiles/ms/icons/bus.png',
            map: map
          });
            var content = "<a href='{{url('/dashboard/buses')}}/"+featuresa[i].id+"' target='_blank'> <h6> عرض الباص "+  ' </h6> </a>' 

            var infowindow = new google.maps.InfoWindow()

            google.maps.event.addListener(marker,'click', (function(marker,content,infowindow){ 
                    return function() {
                    infowindow.setContent(content);
                    infowindow.open(map,marker);
                    };
                })(marker,content,infowindow)); 
        };
      }
    </script>
    <script async defer
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyD97MZ5vtAVyvR4j3YpHfK_0qhojspqOMY&callback=initMap">
    </script>
@endsection