@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<div class="row">
                   <div class="col-sm-12 m-b-15">
                        <div class="btn-group pull-right m-t-15">
                            <a href="/dashboard/schools/{{$school->id}}/edit" class="btn btn-info waves-effect w-md waves-light m-b-5">
                                <i class="fa fa-pencil m-r-5"></i>
                                <span>تعديل</span>
                            </a>

                            <a href="{{route('schools.destroy',$school)}}" id="delete-btn" class="btn btn-info btn-danger waves-effect w-md waves-light m-b-5 m-l-5">
                                <i class="fa fa-remove"></i>
                                <span>حذف</span>
                            </a>
                        </div>
                        <h4 class="page-title"><i class="fa fa-home"></i>   {{ $school->name }} </h4>
                    </div>
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-color panel-tabs panel-success">
                            <div class="panel-heading panel-heading-custom">
                                <ul class="nav nav-pills">
                                    <li class="active">
                                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                                    </li>
                                    <li class="">
                                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">الحافلات</a>
                                    </li>
                                    <li class="">
                                        <a href="#navpills-3" data-toggle="tab" aria-expanded="false">السائقين</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="panel-body">
                                <div class="tab-content">
                                    <div id="navpills-1" class="tab-pane fade in active">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="4">البيانات الأساسية</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الاسم</td>
                                                            <td>{{$school->name}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>البريد الالكتروني</td>
                                                            <td>{{$school->email}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الجوال</td>
                                                            <td>{{$school->phone}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                    </div>
                                    <div id="navpills-2" class="tab-pane fade">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                <thead>
                                                    <tr>
                                                        <th>الرقم</th>
                                                        <th>اسم السائق</th>
                                                        <th>رقم الجول  </th>
                                                        <th> المرحلة التعليميه </th>
                                                        <th> فئة الحافله   </th>
                                                        <th> نوع الحافله  </th>
                                                        <th> رقم الحافله</th>
                                                       
                                                        <!-- <th>الحاله</th> -->
                                                        <th>عرض </th>
                                                        <th>تعديل</th>
                                                        <th>حذف</th>
                                                    </tr>
                                                </thead>

                                                <tbody>
                                                    @foreach($school->OrganizationBus()->get() as $bus)
                                                    @php $item = $bus->Bus()->first() @endphp
                                                    <tr>
                                                        <td>{{$item->id}}</td>
                                                        <td> {{ $item->Driver->name ?? '' }} </td>
                                                        <td>  {{ $item->Driver->phone ?? '' }} </td>
                                                        <td> {{ $item->EducationalLevel->name ?? '' }} </td>
                                                        <td>  {{ $item->BusClass->name ?? '' }}  </td>
                                                        <td>  {{ $item->BusType->name ?? '' }}  </td>
                                                        <td> {{ $item->noard_no ?? '' }}  </td>
                                                        
                                                        <!-- <td> {{__('dashboard.'.$item->status)}} </td> -->
                                                        
                                                        <td><a href="/dashboard/buses/{{$item->id}}" ><i class="fa fa-eye  m-r-10" style="color: #188ae2;"></i> عرض</a></td>
                                                        <td><a href="/dashboard/buses/{{$item->id}}/edit"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                                        <td> <a href="{{route('buses.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                                    </tr>
                                                    @endforeach

                                                </tbody>
                                            </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="navpills-3" class="tab-pane fade">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>اسم </th>
                                                        <th>الايميل</th>
                                                        <th>رقم التليفون</th>
                                                        <th>الصورة</th>
                                                        <th>تعديل</th>
                                                        <th>حذف</th>
                                                        <th>الباص</th>
                                                    </tr>
                                                </thead>

                                                @foreach($school->OrganizationDriver()->get() as $item)
                                                    <tr>
                                                        <td> {{$item->Driver->id}}</td>
                                                        <td> <a href="{{route('drivers.show',$item->Driver->id)}}">{{$item->Driver->name}}</a></td>
                                                        <td>{{$item->Driver->email}}</td>
                                                        <td>{{$item->Driver->phone}}</td>
                                                        <td>
                                                            <img src="{{GetImage($item->Driver->image)}}" height="100" width="100">
                                                        </td>
                                                        <td><a href="{{ route('drivers.edit', $item->Driver->id) }}"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                                        
                                                        <td> <a href="{{route('drivers.destroy',$item->Driver)}}" id="delete-btn"  ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                                        <td>
                                                            <!-- <a href="{{route('sons.index',$item->Driver->id)}}" class="btn waves-effect btn-default pull-right client-info" > عرض </a> -->
                                                            @if( $item->Driver->Bus()->first() )
                                                            <a href="{{ route('buses.show', $item->Driver->Bus->id) }}">عرض الباص</a>
                                                            @else
                                                            <a href="{{ route('buses.create').'?driver_id='.$item->Driver->id }}">اضافة الباص</a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                            </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                </div>
                <!-- end row -->

@endsection
@section('script')
@endsection